----BLINKY---
mobs:register_mob("beast:beast", {
type = "monster",
	hp_max = 50,
	stepheight = 3,
	pathfinding = true,
	visual_size = {x=2, y=2},
	collisionbox =  {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
	visual = "mesh",
	mesh = "beast.b3d",
	textures = {
		{"beast.png"},
	},
	view_range = 10000,
	walk_velocity = 3,
	run_velocity = 4,
	damage = 2,
	drops = {},
	armor = 200,
	drawtype = "front",
	water_damage = 0,
	lava_damage = 1,
	light_damage = 0,
	jump = true,
	suffocation = 0,
	reach = 1,
	fear_height = 0,
	walk_chance = 100,
	stand_chance = 50,
	attack_chance = 50,
	blood_amount = 0,
	randomly_turn = true,
	passive = false,
	group_attack = false,
	attack_players = true,
	attack_type = "dogfight",
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	selectionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	animation = {
		stand_start = 0,
		stand_end = 225,
		stand_speed = 15,
		walk_start = 169,
		walk_end = 186,
		walk_speed = 15,
		run_start = 200,
		run_end = 220,
		run_speed = 20,
		punch_start = 189,
		punch_end = 200,
		punch2_start = 200,
		punch2_end = 220,
		punch_speed = 21,
		die_start = 160,
		die_end = 165,
		die_speed = 15,
	},
})

local MP = minetest.get_modpath(minetest.get_current_modname()) .. "/"
local input = io.open(MP .. "spawn.lua", "r")

if input then
	input:close()
	input = nil
	dofile(MP .. "spawn.lua")
else

	mobs:spawn({
		name = "beast:beast",
		nodes = {"misc:skull"},
		neighbors = "air",
		chance = 7000,
		active_object_count = 2,
		min_height = -31000,
		max_height = 31000,
	})

end

mobs:register_spawn("beast:beast", {"misc:skull"}, 20, -1, 14000, 1, -64)

mobs:register_egg("beast:beast", "beast", "beast.png", 3)

minetest.register_node("beast:spawner_node", {
    description = "Beast Spawner",
    tiles = { "break_me.png" },
    is_ground_content = false,
    groups = { crumbly = 1 },

    -- Function when the node is broken
    on_dig = function(pos, node, digger)
        -- Spawn the beast entity at the position of the node
        minetest.add_entity(pos, "beast:beast")

        -- Send a chat message to all players
        minetest.chat_send_all("The beast has been unleashed!")

        -- Remove the node after being broken
        minetest.remove_node(pos)
    end,
})
